<?php
// test_connection.php - Fișier de debugging
// Rulează acest fișier pentru a verifica toate componentele

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Test Conexiune - Help Desk IT</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .test-box { background: white; padding: 20px; margin: 10px 0; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        h1 { color: #333; }
        h2 { color: #666; margin-top: 20px; }
        code { background: #f0f0f0; padding: 2px 6px; border-radius: 3px; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        table td { padding: 8px; border-bottom: 1px solid #ddd; }
        table td:first-child { font-weight: bold; width: 200px; }
    </style>
</head>
<body>
    <h1>🔧 Test Sistem Help Desk IT</h1>";

// Test 1: Verificare PHP
echo "<div class='test-box'>";
echo "<h2>1. Verificare PHP</h2>";
echo "<table>";
echo "<tr><td>Versiune PHP:</td><td><code>" . phpversion() . "</code> ";
if (version_compare(phpversion(), '7.4.0', '>=')) {
    echo "<span class='success'>✓ OK</span>";
} else {
    echo "<span class='error'>✗ Versiune prea veche (minim 7.4)</span>";
}
echo "</td></tr>";
echo "<tr><td>PDO disponibil:</td><td>";
if (extension_loaded('pdo')) {
    echo "<span class='success'>✓ DA</span>";
} else {
    echo "<span class='error'>✗ NU - Instalează extensia PDO!</span>";
}
echo "</td></tr>";
echo "<tr><td>PDO MySQL disponibil:</td><td>";
if (extension_loaded('pdo_mysql')) {
    echo "<span class='success'>✓ DA</span>";
} else {
    echo "<span class='error'>✗ NU - Instalează extensia PDO_MySQL!</span>";
}
echo "</td></tr>";
echo "<tr><td>Sesiuni activate:</td><td>";
if (function_exists('session_start')) {
    echo "<span class='success'>✓ DA</span>";
} else {
    echo "<span class='error'>✗ NU</span>";
}
echo "</td></tr>";
echo "</table>";
echo "</div>";

// Test 2: Verificare fișier config.php
echo "<div class='test-box'>";
echo "<h2>2. Verificare fișier config.php</h2>";
if (file_exists('config.php')) {
    echo "<span class='success'>✓ Fișierul config.php există</span><br>";
    require_once 'config.php';
    echo "<table>";
    echo "<tr><td>DB_HOST:</td><td><code>" . DB_HOST . "</code></td></tr>";
    echo "<tr><td>DB_NAME:</td><td><code>" . DB_NAME . "</code></td></tr>";
    echo "<tr><td>DB_USER:</td><td><code>" . DB_USER . "</code></td></tr>";
    echo "<tr><td>DB_PASS:</td><td><code>" . (empty(DB_PASS) ? '(gol)' : '***') . "</code></td></tr>";
    echo "</table>";
} else {
    echo "<span class='error'>✗ Fișierul config.php NU EXISTĂ!</span>";
}
echo "</div>";

// Test 3: Testare conexiune MySQL
echo "<div class='test-box'>";
echo "<h2>3. Testare conexiune MySQL</h2>";
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    echo "<span class='success'>✓ Conexiune la MySQL reușită</span><br>";
    
    // Verifică dacă baza de date există
    $stmt = $pdo->query("SHOW DATABASES LIKE '" . DB_NAME . "'");
    if ($stmt->rowCount() > 0) {
        echo "<span class='success'>✓ Baza de date '" . DB_NAME . "' există</span><br>";
        
        // Conectează-te la baza de date
        $pdo->exec("USE " . DB_NAME);
        
        // Verifică tabelele
        echo "<h3>Tabele găsite:</h3>";
        $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
        if (count($tables) > 0) {
            echo "<ul>";
            foreach ($tables as $table) {
                echo "<li><code>$table</code></li>";
            }
            echo "</ul>";
            
            // Verifică utilizatorul admin
            echo "<h3>Verificare utilizator admin:</h3>";
            $stmt = $pdo->query("SELECT * FROM users WHERE username = 'admin'");
            $admin = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($admin) {
                echo "<span class='success'>✓ Utilizatorul 'admin' există</span><br>";
                echo "<table>";
                echo "<tr><td>ID:</td><td>" . $admin['id'] . "</td></tr>";
                echo "<tr><td>Email:</td><td>" . htmlspecialchars($admin['email']) . "</td></tr>";
                echo "<tr><td>Nume complet:</td><td>" . htmlspecialchars($admin['full_name']) . "</td></tr>";
                echo "<tr><td>Rol:</td><td>" . $admin['role'] . "</td></tr>";
                echo "<tr><td>Activ:</td><td>" . ($admin['is_active'] ? 'DA' : 'NU') . "</td></tr>";
                echo "</table>";
                
                // Test parola
                if (password_verify('admin123', $admin['password'])) {
                    echo "<span class='success'>✓ Parola 'admin123' este corectă</span><br>";
                } else {
                    echo "<span class='error'>✗ Parola 'admin123' NU funcționează - resetează parola!</span><br>";
                    echo "<p>Rulează acest SQL pentru a reseta parola:</p>";
                    echo "<code>UPDATE users SET password = '" . password_hash('admin123', PASSWORD_DEFAULT) . "' WHERE username = 'admin';</code>";
                }
            } else {
                echo "<span class='error'>✗ Utilizatorul 'admin' NU există în baza de date!</span><br>";
                echo "<p>Rulează acest SQL pentru a crea utilizatorul:</p>";
                echo "<code>INSERT INTO users (username, email, password, full_name, role) VALUES ('admin', 'admin@company.com', '" . password_hash('admin123', PASSWORD_DEFAULT) . "', 'Administrator', 'admin');</code>";
            }
        } else {
            echo "<span class='error'>✗ Nicio tabelă găsită - importă schema SQL!</span>";
        }
    } else {
        echo "<span class='error'>✗ Baza de date '" . DB_NAME . "' NU EXISTĂ!</span><br>";
        echo "<p>Creează baza de date cu:</p>";
        echo "<code>CREATE DATABASE " . DB_NAME . " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;</code>";
    }
} catch (PDOException $e) {
    echo "<span class='error'>✗ Eroare conexiune: " . htmlspecialchars($e->getMessage()) . "</span>";
}
echo "</div>";

// Test 4: Verificare sesiuni
echo "<div class='test-box'>";
echo "<h2>4. Verificare sesiuni</h2>";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "<span class='success'>✓ Sesiunea este activă</span><br>";
} else {
    if (session_start()) {
        echo "<span class='success'>✓ Sesiunea a fost pornită cu succes</span><br>";
    } else {
        echo "<span class='error'>✗ Nu se poate porni sesiunea!</span><br>";
    }
}
echo "<table>";
echo "<tr><td>Session ID:</td><td><code>" . session_id() . "</code></td></tr>";
echo "<tr><td>Session Save Path:</td><td><code>" . session_save_path() . "</code></td></tr>";
echo "</table>";
echo "</div>";

// Test 5: Verificare permisiuni
echo "<div class='test-box'>";
echo "<h2>5. Verificare fișiere</h2>";
$files = ['config.php', 'login.php', 'dashboard.php', 'incidents.php', 'ritm.php', 'assets.php', 'users.php', 'style.css', 'header.php', 'logout.php'];
echo "<table>";
foreach ($files as $file) {
    echo "<tr><td><code>$file</code></td><td>";
    if (file_exists($file)) {
        echo "<span class='success'>✓ Există</span> ";
        if (is_readable($file)) {
            echo "<span class='success'>(citibil)</span>";
        } else {
            echo "<span class='error'>(NU e citibil - verifică permisiunile!)</span>";
        }
    } else {
        echo "<span class='error'>✗ NU există</span>";
    }
    echo "</td></tr>";
}
echo "</table>";
echo "</div>";

// Test 6: Test autentificare
echo "<div class='test-box'>";
echo "<h2>6. Test formular autentificare</h2>";
echo "<form method='POST' action='login.php' style='padding: 10px; background: #f9f9f9; border-radius: 5px;'>";
echo "<p><strong>Test rapid autentificare:</strong></p>";
echo "<label>Username: <input type='text' name='username' value='admin' style='padding: 5px;'></label><br><br>";
echo "<label>Parolă: <input type='password' name='password' value='admin123' style='padding: 5px;'></label><br><br>";
echo "<button type='submit' style='padding: 8px 20px; background: #667eea; color: white; border: none; border-radius: 5px; cursor: pointer;'>Testează Login</button>";
echo "</form>";
echo "</div>";

echo "<div class='test-box' style='background: #e8f5e9;'>";
echo "<h2>✅ Rezumat</h2>";
echo "<p>Dacă toate testele sunt <span class='success'>✓ OK</span>, aplicația ar trebui să funcționeze corect.</p>";
echo "<p>Dacă vezi erori <span class='error'>✗</span>, urmărește instrucțiunile de remediere.</p>";
echo "<p><a href='login.php' style='color: #667eea; font-weight: bold;'>→ Încearcă să te autentifici</a></p>";
echo "</div>";

echo "</body></html>";
?>