<?php
// login.php
require_once 'config.php';

// Dacă utilizatorul este deja autentificat, redirecționează la dashboard
if (isLoggedIn()) {
    header('Location: dashboard.php');
    exit;
}

$error = '';

// Procesare formular de login
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($username) || empty($password)) {
        $error = 'Te rog completează toate câmpurile!';
    } else {
        try {
            $db = Database::getInstance()->getConnection();
            $stmt = $db->prepare("SELECT * FROM users WHERE username = ? AND is_active = 1");
            $stmt->execute([$username]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($user && password_verify($password, $user['password'])) {
                // Autentificare reușită
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['user_role'] = $user['role'];
                $_SESSION['full_name'] = $user['full_name'];
                
                // Log activitate
                logActivity($user['id'], 'login', 'user', $user['id'], 'Autentificare reușită');
                
                // Redirecționare la dashboard
                header('Location: dashboard.php');
                exit;
            } else {
                $error = 'Utilizator sau parolă incorectă!';
            }
        } catch (PDOException $e) {
            $error = 'Eroare la autentificare. Te rog încearcă din nou.';
            error_log("Login error: " . $e->getMessage());
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ro">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Help Desk IT</title>
    <style>
        * { 
            margin: 0; 
            padding: 0; 
            box-sizing: border-box; 
        }
        
        body { 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            min-height: 100vh; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            padding: 20px;
        }
        
        .login-container { 
            background: white; 
            padding: 40px; 
            border-radius: 10px; 
            box-shadow: 0 10px 40px rgba(0,0,0,0.1); 
            width: 100%; 
            max-width: 400px; 
        }
        
        .login-container h1 { 
            color: #333; 
            margin-bottom: 10px; 
            font-size: 28px; 
            text-align: center;
        }
        
        .login-container p { 
            color: #666; 
            margin-bottom: 30px; 
            text-align: center;
            font-size: 14px;
        }
        
        .form-group { 
            margin-bottom: 20px; 
        }
        
        .form-group label { 
            display: block; 
            margin-bottom: 8px; 
            color: #555; 
            font-weight: 500; 
        }
        
        .form-group input { 
            width: 100%; 
            padding: 12px 15px; 
            border: 1px solid #ddd; 
            border-radius: 5px; 
            font-size: 14px; 
            transition: border-color 0.3s;
        }
        
        .form-group input:focus { 
            outline: none; 
            border-color: #667eea; 
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn { 
            width: 100%; 
            padding: 12px; 
            background: #667eea; 
            color: white; 
            border: none; 
            border-radius: 5px; 
            font-size: 16px; 
            font-weight: 600; 
            cursor: pointer; 
            transition: background 0.3s;
        }
        
        .btn:hover { 
            background: #5568d3; 
        }
        
        .btn:active {
            transform: translateY(1px);
        }
        
        .error { 
            background: #fee; 
            border: 1px solid #fcc; 
            color: #c33; 
            padding: 12px; 
            border-radius: 5px; 
            margin-bottom: 20px; 
            font-size: 14px;
        }
        
        .info-box {
            background: #e3f2fd;
            border: 1px solid #90caf9;
            color: #1565c0;
            padding: 12px;
            border-radius: 5px;
            margin-top: 20px;
            font-size: 13px;
        }
        
        .info-box strong {
            display: block;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h1>🎫 Help Desk IT</h1>
        <p>Sistem de management ticketing și asset-uri</p>
        
        <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <form method="POST" action="login.php">
            <div class="form-group">
                <label for="username">Utilizator</label>
                <input type="text" id="username" name="username" required autofocus placeholder="Introdu username">
            </div>
            
            <div class="form-group">
                <label for="password">Parolă</label>
                <input type="password" id="password" name="password" required placeholder="Introdu parola">
            </div>
            
            <button type="submit" class="btn">Autentificare</button>
        </form>
        
        <div class="info-box">
            <strong>📋 Cont de test:</strong>
            Username: <strong>admin</strong><br>
            Parolă: <strong>admin123</strong>
        </div>
    </div>
</body>
</html>