<?php
// header.php - Navigație
$currentUser = getCurrentUser();
?>
<header class="header">
    <div class="header-content">
        <div class="logo">
            <a href="dashboard.php">🎫 AMBIT Consult - Help Desk IT</a>
        </div>
        <nav class="nav">
            <a href="dashboard.php" class="nav-link">Dashboard</a>
            <a href="incidents.php" class="nav-link">Incidente</a>
            <a href="ritm.php" class="nav-link">RITM-uri</a>
            <?php if (hasRole(['admin', 'technician'])): ?>
            <a href="assets.php" class="nav-link">Asset-uri</a>
            <?php endif; ?>
            <?php if (hasRole('admin')): ?>
            <a href="users.php" class="nav-link">Utilizatori</a>
            <?php endif; ?>
        </nav>
        <div class="user-menu">
            <span class="user-name"><?= htmlspecialchars($currentUser['full_name']) ?></span>
            <span class="user-role">(<?= htmlspecialchars($currentUser['role']) ?>)</span>
            <a href="logout.php" class="btn btn-sm">Logout</a>
        </div>
    </div>
</header>


