
<?php
// dashboard.php
require_once 'config.php';
requireLogin();

$db = Database::getInstance()->getConnection();
$user = getCurrentUser();

// Statistici
$stats = [];

// Incidente
$stmt = $db->prepare("SELECT status, COUNT(*) as count FROM incidents " . 
    (hasRole(['admin', 'technician']) ? "" : "WHERE reporter_id = ?") . 
    " GROUP BY status");
hasRole(['admin', 'technician']) ? $stmt->execute() : $stmt->execute([$user['id']]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $stats['incidents'][$row['status']] = $row['count'];
}

// RITM-uri
$stmt = $db->prepare("SELECT status, COUNT(*) as count FROM ritm " . 
    (hasRole(['admin', 'technician']) ? "" : "WHERE requester_id = ?") . 
    " GROUP BY status");
hasRole(['admin', 'technician']) ? $stmt->execute() : $stmt->execute([$user['id']]);
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $stats['ritm'][$row['status']] = $row['count'];
}

// Asset-uri (doar admin/technician)
if (hasRole(['admin', 'technician'])) {
    $stmt = $db->query("SELECT status, COUNT(*) as count FROM assets GROUP BY status");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $stats['assets'][$row['status']] = $row['count'];
    }
}
?>
<!DOCTYPE html>
<html lang="ro">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Help Desk IT</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="container">
        <h1>Dashboard</h1>
        <p>Bine ai venit, <?= htmlspecialchars($user['full_name']) ?>!</p>
        
        <div class="stats-grid">
            <div class="stat-card">
                <h3>Incidente Active</h3>
                <div class="stat-number"><?= array_sum($stats['incidents'] ?? []) ?></div>
                <div class="stat-details">
                    <?php foreach ($stats['incidents'] ?? [] as $status => $count): ?>
                    <span><?= ucfirst($status) ?>: <?= $count ?></span>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <div class="stat-card">
                <h3>Cereri RITM</h3>
                <div class="stat-number"><?= array_sum($stats['ritm'] ?? []) ?></div>
                <div class="stat-details">
                    <?php foreach ($stats['ritm'] ?? [] as $status => $count): ?>
                    <span><?= ucfirst($status) ?>: <?= $count ?></span>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <?php if (hasRole(['admin', 'technician'])): ?>
            <div class="stat-card">
                <h3>Asset-uri</h3>
                <div class="stat-number"><?= array_sum($stats['assets'] ?? []) ?></div>
                <div class="stat-details">
                    <?php foreach ($stats['assets'] ?? [] as $status => $count): ?>
                    <span><?= ucfirst($status) ?>: <?= $count ?></span>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="quick-actions">
            <h2>Acțiuni rapide</h2>
            <div class="action-buttons">
                <a href="incidents.php?action=create" class="btn btn-primary">Raportează Incident</a>
                <a href="ritm.php?action=create" class="btn btn-primary">Cerere Asset Nou</a>
                <a href="incidents.php" class="btn">Vizualizează Incidente</a>
                <a href="ritm.php" class="btn">Vizualizează RITM-uri</a>
                <?php if (hasRole(['admin', 'technician'])): ?>
                <a href="assets.php" class="btn">Gestionează Asset-uri</a>
                <?php endif; ?>
                <?php if (hasRole('admin')): ?>
                <a href="users.php" class="btn">Gestionează Utilizatori</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>