<?php
// config.php - Configurare conexiune bază de date
session_start();

define('DB_HOST', 'localhost');
define('DB_NAME', 'vlrvuqur_helpdesk_it');
define('DB_USER', 'vlrvuqur_cipp29');
define('DB_PASS', 'Adelina.Maria2024.1');

class Database {
    private static $instance = null;
    private $conn;
    
    private function __construct() {
        try {
            $this->conn = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
                ]
            );
        } catch(PDOException $e) {
            die("Eroare conexiune: " . $e->getMessage());
        }
    }
    
    public static function getInstance() {
        if (self::$instance == null) {
            self::$instance = new Database();
        }
        return self::$instance;
    }
    
    public function getConnection() {
        return $this->conn;
    }
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

function hasRole($roles) {
    if (!isLoggedIn()) return false;
    return in_array($_SESSION['user_role'], (array)$roles);
}

function getCurrentUser() {
    if (!isLoggedIn()) return null;
    return [
        'id' => $_SESSION['user_id'],
        'username' => $_SESSION['username'],
        'role' => $_SESSION['user_role'],
        'full_name' => $_SESSION['full_name']
    ];
}

function logActivity($userId, $action, $entityType, $entityId, $details = null) {
    try {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->prepare("INSERT INTO activity_log (user_id, action, entity_type, entity_id, details) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$userId, $action, $entityType, $entityId, $details]);
    } catch (Exception $e) {
        error_log("Log activity error: " . $e->getMessage());
    }
}

function generateRITMNumber($conn) {
    $stmt = $conn->query("SELECT MAX(CAST(SUBSTRING(ritm_number, 5) AS UNSIGNED)) as max_num FROM ritm");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $nextNum = ($result['max_num'] ?? 0) + 1;
    return 'RITM' . str_pad($nextNum, 7, '0', STR_PAD_LEFT);
}

function generateSCTASKNumber($conn) {
    $stmt = $conn->query("SELECT MAX(CAST(SUBSTRING(sctask_number, 7) AS UNSIGNED)) as max_num FROM sctask");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $nextNum = ($result['max_num'] ?? 0) + 1;
    return 'SCTASK' . str_pad($nextNum, 7, '0', STR_PAD_LEFT);
}

function generateINCNumber($conn) {
    $stmt = $conn->query("SELECT MAX(CAST(SUBSTRING(inc_number, 4) AS UNSIGNED)) as max_num FROM incidents");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $nextNum = ($result['max_num'] ?? 0) + 1;
    return 'INC' . str_pad($nextNum, 7, '0', STR_PAD_LEFT);
}

function createSCTASKsForRITM($ritmId) {
    $db = Database::getInstance()->getConnection();
    
    $stmt = $db->prepare("SELECT * FROM ritm WHERE id = ? AND status = 'approved'");
    $stmt->execute([$ritmId]);
    $ritm = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$ritm) return false;
    
    $tasks = [
        ['type' => 'procurement', 'description' => 'Achizitie asset: ' . $ritm['asset_type']],
        ['type' => 'configuration', 'description' => 'Configurare si pregatire asset'],
        ['type' => 'deployment', 'description' => 'Livrare si instalare la utilizator'],
        ['type' => 'documentation', 'description' => 'Documentare si inchidere asset in sistem']
    ];
    
    foreach ($tasks as $task) {
        $taskNumber = generateSCTASKNumber($db);
        $stmt = $db->prepare("INSERT INTO sctask (sctask_number, ritm_id, task_description, task_type, priority, assigned_to) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $taskNumber,
            $ritmId,
            $task['description'],
            $task['type'],
            $ritm['priority'],
            $ritm['assigned_to']
        ]);
    }
    
    return true;
}
?>