<?php
// assets.php - Management asset-uri
require_once 'config.php';
requireLogin();

if (!hasRole(['admin', 'technician'])) {
    header('Location: dashboard.php');
    exit;
}

$db = Database::getInstance()->getConnection();
$user = getCurrentUser();
$action = $_GET['action'] ?? 'list';

// Creare asset nou
if ($action == 'create' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $assetTag = $_POST['asset_tag'];
    $assetType = $_POST['asset_type'];
    $brand = $_POST['brand'];
    $model = $_POST['model'];
    $serialNumber = $_POST['serial_number'];
    $status = $_POST['status'];
    $assignedTo = !empty($_POST['assigned_to']) ? $_POST['assigned_to'] : null;
    $purchaseDate = !empty($_POST['purchase_date']) ? $_POST['purchase_date'] : null;
    $warrantyExpiry = !empty($_POST['warranty_expiry']) ? $_POST['warranty_expiry'] : null;
    $location = $_POST['location'];
    $notes = $_POST['notes'];
    
    try {
        $stmt = $db->prepare("INSERT INTO assets (asset_tag, asset_type, brand, model, serial_number, status, assigned_to, purchase_date, warranty_expiry, location, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$assetTag, $assetType, $brand, $model, $serialNumber, $status, $assignedTo, $purchaseDate, $warrantyExpiry, $location, $notes]);
        $assetId = $db->lastInsertId();
        
        logActivity($user['id'], 'create_asset', 'asset', $assetId, "Creat asset: $assetTag");
        
        header("Location: assets.php?action=view&id=$assetId&msg=created");
        exit;
    } catch (PDOException $e) {
        $error = "Eroare la crearea asset-ului: " . $e->getMessage();
    }
}

// Actualizare asset
if ($action == 'update' && $_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $assetType = $_POST['asset_type'];
    $brand = $_POST['brand'];
    $model = $_POST['model'];
    $serialNumber = $_POST['serial_number'];
    $status = $_POST['status'];
    $assignedTo = !empty($_POST['assigned_to']) ? $_POST['assigned_to'] : null;
    $purchaseDate = !empty($_POST['purchase_date']) ? $_POST['purchase_date'] : null;
    $warrantyExpiry = !empty($_POST['warranty_expiry']) ? $_POST['warranty_expiry'] : null;
    $location = $_POST['location'];
    $notes = $_POST['notes'];
    
    try {
        $stmt = $db->prepare("UPDATE assets SET asset_type = ?, brand = ?, model = ?, serial_number = ?, status = ?, assigned_to = ?, purchase_date = ?, warranty_expiry = ?, location = ?, notes = ? WHERE id = ?");
        $stmt->execute([$assetType, $brand, $model, $serialNumber, $status, $assignedTo, $purchaseDate, $warrantyExpiry, $location, $notes, $id]);
        
        logActivity($user['id'], 'update_asset', 'asset', $id);
        
        header("Location: assets.php?action=view&id=$id&msg=updated");
        exit;
    } catch (PDOException $e) {
        $error = "Eroare la actualizarea asset-ului: " . $e->getMessage();
    }
}

// Vizualizare asset
if ($action == 'view') {
    $id = $_GET['id'];
    $stmt = $db->prepare("SELECT a.*, u.full_name as assigned_user_name FROM assets a LEFT JOIN users u ON a.assigned_to = u.id WHERE a.id = ?");
    $stmt->execute([$id]);
    $asset = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$asset) {
        header('Location: assets.php');
        exit;
    }
    
    // Istoric incidente legate de acest asset
    $stmt = $db->prepare("SELECT inc_number, title, status, created_at FROM incidents WHERE asset_id = ? ORDER BY created_at DESC LIMIT 10");
    $stmt->execute([$id]);
    $relatedIncidents = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Utilizatori pentru asignare
    $users = $db->query("SELECT id, full_name FROM users WHERE is_active = 1 ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
}

// Listare asset-uri
if ($action == 'list') {
    $filter = $_GET['filter'] ?? 'all';
    $search = $_GET['search'] ?? '';
    
    $sql = "SELECT a.*, u.full_name as assigned_user_name FROM assets a LEFT JOIN users u ON a.assigned_to = u.id WHERE 1=1 ";
    
    if ($filter != 'all') {
        $sql .= " AND a.status = :filter ";
    }
    
    if ($search) {
        $sql .= " AND (a.asset_tag LIKE :search OR a.brand LIKE :search OR a.model LIKE :search OR a.serial_number LIKE :search) ";
    }
    
    $sql .= " ORDER BY a.created_at DESC LIMIT 200";
    
    $stmt = $db->prepare($sql);
    if ($filter != 'all') {
        $stmt->bindValue(':filter', $filter);
    }
    if ($search) {
        $stmt->bindValue(':search', "%$search%");
    }
    $stmt->execute();
    $assets = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$pageTitle = $action == 'view' ? 'Detalii Asset' : ($action == 'create' ? 'Asset Nou' : 'Asset-uri');
?>
<!DOCTYPE html>
<html lang="ro">
<head>
    <meta charset="UTF-8">
    <title><?= $pageTitle ?> - Help Desk IT</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="container">
        <?php if ($action == 'list'): ?>
            <div class="page-header">
                <h1>Asset Management</h1>
                <a href="assets.php?action=create" class="btn btn-primary">Asset Nou</a>
            </div>
            
            <div class="filters-row">
                <div class="filters">
                    <a href="?filter=all" class="filter-btn <?= $filter == 'all' ? 'active' : '' ?>">Toate</a>
                    <a href="?filter=available" class="filter-btn <?= $filter == 'available' ? 'active' : '' ?>">Disponibile</a>
                    <a href="?filter=assigned" class="filter-btn <?= $filter == 'assigned' ? 'active' : '' ?>">Asignate</a>
                    <a href="?filter=maintenance" class="filter-btn <?= $filter == 'maintenance' ? 'active' : '' ?>">Mentenanță</a>
                    <a href="?filter=retired" class="filter-btn <?= $filter == 'retired' ? 'active' : '' ?>">Retrase</a>
                </div>
                <form method="GET" class="search-form">
                    <input type="hidden" name="filter" value="<?= htmlspecialchars($filter) ?>">
                    <input type="text" name="search" placeholder="Caută asset..." value="<?= htmlspecialchars($search) ?>">
                    <button type="submit" class="btn btn-sm">Caută</button>
                </form>
            </div>
            
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Asset Tag</th>
                        <th>Tip</th>
                        <th>Brand / Model</th>
                        <th>Serial Number</th>
                        <th>Status</th>
                        <th>Asignat la</th>
                        <th>Locație</th>
                        <th>Garanție</th>
                        <th>Acțiuni</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($assets as $a): ?>
                    <tr>
                        <td><strong><?= htmlspecialchars($a['asset_tag']) ?></strong></td>
                        <td><span class="badge badge-info"><?= htmlspecialchars($a['asset_type']) ?></span></td>
                        <td><?= htmlspecialchars($a['brand'] . ' ' . $a['model']) ?></td>
                        <td><?= htmlspecialchars($a['serial_number']) ?></td>
                        <td><span class="status-<?= $a['status'] ?>"><?= ucfirst($a['status']) ?></span></td>
                        <td><?= $a['assigned_user_name'] ? htmlspecialchars($a['assigned_user_name']) : '-' ?></td>
                        <td><?= htmlspecialchars($a['location']) ?></td>
                        <td>
                            <?php if ($a['warranty_expiry']): ?>
                                <?php 
                                $expiry = strtotime($a['warranty_expiry']);
                                $isExpired = $expiry < time();
                                ?>
                                <span class="<?= $isExpired ? 'text-danger' : '' ?>">
                                    <?= date('d.m.Y', $expiry) ?>
                                </span>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td><a href="?action=view&id=<?= $a['id'] ?>" class="btn btn-sm">Vizualizează</a></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
        <?php elseif ($action == 'create' || $action == 'edit'): ?>
            <h1><?= $action == 'create' ? 'Asset Nou' : 'Editare Asset' ?></h1>
            
            <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <?php 
            if ($action == 'edit') {
                $id = $_GET['id'];
                $stmt = $db->prepare("SELECT * FROM assets WHERE id = ?");
                $stmt->execute([$id]);
                $asset = $stmt->fetch(PDO::FETCH_ASSOC);
                
                $users = $db->query("SELECT id, full_name FROM users WHERE is_active = 1 ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);
            }
            ?>
            
            <form method="POST" action="?action=<?= $action == 'create' ? 'create' : 'update' ?>" class="form">
                <?php if ($action == 'edit'): ?>
                <input type="hidden" name="id" value="<?= $asset['id'] ?>">
                <?php endif; ?>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Asset Tag *</label>
                        <input type="text" name="asset_tag" required value="<?= $action == 'edit' ? htmlspecialchars($asset['asset_tag']) : '' ?>" <?= $action == 'edit' ? 'readonly' : '' ?>>
                    </div>
                    
                    <div class="form-group">
                        <label>Tip Asset *</label>
                        <select name="asset_type" required>
                            <option value="">Selectează...</option>
                            <?php 
                            $types = ['laptop', 'desktop', 'server', 'printer', 'phone', 'tablet', 'network', 'other'];
                            foreach ($types as $type):
                            ?>
                            <option value="<?= $type ?>" <?= ($action == 'edit' && $asset['asset_type'] == $type) ? 'selected' : '' ?>>
                                <?= ucfirst($type) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Brand</label>
                        <input type="text" name="brand" value="<?= $action == 'edit' ? htmlspecialchars($asset['brand']) : '' ?>">
                    </div>
                    
                    <div class="form-group">
                        <label>Model</label>
                        <input type="text" name="model" value="<?= $action == 'edit' ? htmlspecialchars($asset['model']) : '' ?>">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Serial Number</label>
                    <input type="text" name="serial_number" value="<?= $action == 'edit' ? htmlspecialchars($asset['serial_number']) : '' ?>">
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Status *</label>
                        <select name="status" required>
                            <option value="available" <?= ($action == 'edit' && $asset['status'] == 'available') ? 'selected' : '' ?>>Disponibil</option>
                            <option value="assigned" <?= ($action == 'edit' && $asset['status'] == 'assigned') ? 'selected' : '' ?>>Asignat</option>
                            <option value="maintenance" <?= ($action == 'edit' && $asset['status'] == 'maintenance') ? 'selected' : '' ?>>Mentenanță</option>
                            <option value="retired" <?= ($action == 'edit' && $asset['status'] == 'retired') ? 'selected' : '' ?>>Retras</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>Asignat la</label>
                        <select name="assigned_to">
                            <option value="">- Neasignat -</option>
                            <?php if ($action == 'edit'): foreach ($users as $u): ?>
                            <option value="<?= $u['id'] ?>" <?= ($asset['assigned_to'] == $u['id']) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($u['full_name']) ?>
                            </option>
                            <?php endforeach; endif; ?>
                        </select>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Data achiziție</label>
                        <input type="date" name="purchase_date" value="<?= $action == 'edit' ? $asset['purchase_date'] : '' ?>">
                    </div>
                    
                    <div class="form-group">
                        <label>Expirare garanție</label>
                        <input type="date" name="warranty_expiry" value="<?= $action == 'edit' ? $asset['warranty_expiry'] : '' ?>">
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Locație</label>
                    <input type="text" name="location" value="<?= $action == 'edit' ? htmlspecialchars($asset['location']) : '' ?>">
                </div>
                
                <div class="form-group">
                    <label>Note</label>
                    <textarea name="notes" rows="3"><?= $action == 'edit' ? htmlspecialchars($asset['notes']) : '' ?></textarea>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">Salvează</button>
                    <a href="assets.php" class="btn">Anulează</a>
                </div>
            </form>
            
        <?php elseif ($action == 'view'): ?>
            <?php if (isset($_GET['msg'])): ?>
            <div class="alert alert-success">
                <?php echo $_GET['msg'] == 'created' ? 'Asset creat cu succes!' : 'Asset actualizat cu succes!'; ?>
            </div>
            <?php endif; ?>
            
            <div class="incident-header">
                <div>
                    <h1><?= htmlspecialchars($asset['asset_tag']) ?> - <?= htmlspecialchars($asset['brand'] . ' ' . $asset['model']) ?></h1>
                    <div class="meta">
                        Înregistrat la <?= date('d.m.Y H:i', strtotime($asset['created_at'])) ?>
                    </div>
                </div>
                <span class="status-badge status-<?= $asset['status'] ?>"><?= ucfirst($asset['status']) ?></span>
            </div>
            
            <div class="detail-grid">
                <div class="detail-main">
                    <div class="card">
                        <h3>Informații Asset</h3>
                        <dl class="details-list">
                            <dt>Asset Tag:</dt>
                            <dd><strong><?= htmlspecialchars($asset['asset_tag']) ?></strong></dd>
                            
                            <dt>Tip:</dt>
                            <dd><span class="badge badge-info"><?= htmlspecialchars($asset['asset_type']) ?></span></dd>
                            
                            <dt>Brand:</dt>
                            <dd><?= htmlspecialchars($asset['brand']) ?></dd>
                            
                            <dt>Model:</dt>
                            <dd><?= htmlspecialchars($asset['model']) ?></dd>
                            
                            <dt>Serial Number:</dt>
                            <dd><?= htmlspecialchars($asset['serial_number']) ?></dd>
                            
                            <dt>Status:</dt>
                            <dd><span class="status-<?= $asset['status'] ?>"><?= ucfirst($asset['status']) ?></span></dd>
                            
                            <dt>Asignat la:</dt>
                            <dd><?= $asset['assigned_user_name'] ? htmlspecialchars($asset['assigned_user_name']) : 'Neasignat' ?></dd>
                            
                            <dt>Locație:</dt>
                            <dd><?= htmlspecialchars($asset['location']) ?: '-' ?></dd>
                            
                            <dt>Data achiziție:</dt>
                            <dd><?= $asset['purchase_date'] ? date('d.m.Y', strtotime($asset['purchase_date'])) : '-' ?></dd>
                            
                            <dt>Garanție până la:</dt>
                            <dd>
                                <?php if ($asset['warranty_expiry']): ?>
                                    <?php 
                                    $expiry = strtotime($asset['warranty_expiry']);
                                    $isExpired = $expiry < time();
                                    ?>
                                    <span class="<?= $isExpired ? 'text-danger' : 'text-success' ?>">
                                        <?= date('d.m.Y', $expiry) ?>
                                        <?= $isExpired ? '(Expirată)' : '' ?>
                                    </span>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </dd>
                        </dl>
                        
                        <?php if ($asset['notes']): ?>
                        <div class="mt-3">
                            <strong>Note:</strong>
                            <p><?= nl2br(htmlspecialchars($asset['notes'])) ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <?php if (!empty($relatedIncidents)): ?>
                    <div class="card">
                        <h3>Incidente Asociate</h3>
                        <table class="simple-table">
                            <thead>
                                <tr>
                                    <th>Nr. Incident</th>
                                    <th>Titlu</th>
                                    <th>Status</th>
                                    <th>Data</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($relatedIncidents as $inc): ?>
                                <tr>
                                    <td><a href="incidents.php?action=view&id=<?= $inc['inc_number'] ?>"><?= htmlspecialchars($inc['inc_number']) ?></a></td>
                                    <td><?= htmlspecialchars($inc['title']) ?></td>
                                    <td><span class="status-<?= $inc['status'] ?>"><?= ucfirst($inc['status']) ?></span></td>
                                    <td><?= date('d.m.Y', strtotime($inc['created_at'])) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="detail-sidebar">
                    <div class="card">
                        <h3>Acțiuni</h3>
                        <a href="assets.php?action=edit&id=<?= $asset['id'] ?>" class="btn btn-block">Editează Asset</a>
                        <a href="assets.php" class="btn btn-block">Înapoi la listă</a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>